/** @file   windingwire.h
 * @brief   Declaration of WindingWire - class.
 * @version $Revision: 1.1.1.1 $
 * @date    $Date: 2006/01/21 23:02:38 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_ENG2D_ELECTRICSPARK_H
#define H_ENG2D_ELECTRICSPARK_H

#include "eng2d_dll.h"
#include "wire.h"
#include "Gradient.h"

namespace eng2d {

/** @class  WindingWire
 * @brief   Represents an electric sparks that changes its form randomly.
 * @author  Tomi Lamminsaari
 *
 * This tries to behave like electric sparks between two tesla coils.
 */
class DLLIMPORT WindingWire : public Wire
{
public:

  ///
  /// Constants, datatype and static members
  /// ======================================


  ///
  /// Constructors, destructor and operators
  /// ======================================

	/** Constructor.
   * @param     rBeg              Beginning coordinate
   * @param     rEnd              Ending coordinate.
   * @param     nodes             Number of nodes this Wire has.
   * @param     windingFactor     The curvature of this wire. If == 0 this
   *                              will be a straight line like normal
   *                              Wire.
   */
	WindingWire( const Vec2D& rBeg, const Vec2D& rEnd, int nodes,
                  int windingFactor );


	/** Destructor
   */
	virtual ~WindingWire();

private:

	/** Copy constructor.
   * @param     rO                Reference to another WindingWire
   */
  WindingWire( const WindingWire& rO );

	/** Assignment operator
   * @param     rO                Reference to another WindingWire
   * @return    Reference to us.
   */
  WindingWire& operator = ( const WindingWire& rO );

public:


  ///
  /// Methods
  /// =======

  /** Updates this Wire. Moves the the nodes randomly by amount of the
   * winding factor. Changes the color of the Wire.
   */
  virtual void update();
  
  /** Sets the gradient we use when picking new colors for the Wire in
   * @c update() - method.
   * @param     rG                The gradient we use as colorscale.
   */
  void setColorScale( const Gradient& rG );

  /** Adjusts the winding factor.
   * @param     f                 New winding factor. The bigger the
   *                              value is, the bigger curvature the
   *                              Wire will have. 0 = straight line.
   *                              Only the absolute value is taken in to
   *                              account.
   */
  void setWindingFactor( int f );
  

  ///
  /// Getter methods
  /// ==============
  
  /** Returns the current Winding factor.
   * @return    Current winding factor.
   */
  int getWindingFactor() const;


protected:

  ///
  /// Members
  /// =======

  /** Current winding factor. */
  int m_windingFactor;
  
  /** The gradient we use when picking new colors for the wire. */
  Gradient m_colorScale;


private:

  ///
  /// Private members
  /// ===============

};

};  // end of namespace

#endif
